/******************************************************************************/
#include "stdafx.h"
#include "../../../../../data/enum/_enums.h"
/******************************************************************************/
struct MeshOverlay2 : MeshOverlay // create a helper class which bases on MeshOverlay and uses time fading
{
   Flt time; // time left until overlay fades out

   MeshOverlay2()
   {
      time=10; // default time is 10 seconds for an overlay to live
   }

   Bool update()
   {
             time-=Tm.d; // decrease time left
      return time<=0   ; // if there is no time left then return true (which means that the overlay can be deleted)
   }
   void draw(Matrix &matrix)
   {
      MeshOverlay::draw(matrix,Sat(time)); // draw the overlay with transparency of 'Saturate(time)' value
   }

   // io
   void save(File &f)
   {
      MeshOverlay::save(f);
      f<<time;
   }
   Bool load(File &f)
   {
      if(MeshOverlay::load(f))
      {
         f>>time;
         return true;
      }
      return false;
   }
};
/******************************************************************************/
struct Item : Game::Item // extend items
{
   I32                type        ; // ITEM_TYPE
   Memb<MeshOverlay2> mesh_overlay; // add mesh overlay, which is used for rendering semi transparent images on solid surfaces

   virtual void create(Game::ObjParams &obj); // extend creation to include accessing item type
   virtual Bool update(                    ); // extend updating to include bomb explosion, and 'mesh_overlay' update
   virtual void draw  (                    ); // extend drawing  to include rendering of 'mesh_overlay'

   // io
   virtual void save(File &f); // extend saving  to include members saving
   virtual Bool load(File &f); // extend loading to include members loading

   Item();
};
/******************************************************************************/
Memb<ExplosionFx> explosion;

Game::ObjMemx<Item> Items;
/******************************************************************************/
void CreateExplosion(Vec &pos) // helper function for creating an explosion at given position
{
   // add an earthquake effect
   QuakeFx.addMedium();

   // create a new explosion effect
   explosion.New().create(Gfxs("gfx/particle/explosion/0.gfx"),Gfxs("gfx/particle/explosion/1.gfx"),0x00600000,32,pos,3);

   // set overlay parameters
   Flt  overlay_angle=RndF(PI2),
        overlay_scale=RndF(4,7);
   Gfx &overlay_gfx  =*Gfxs("gfx/hole/bomb.gfx");

   // add terrain overlay
   Matrix m;
   m.setPosDir     (pos,Vec(0,-1,0)); // set position and direction
   m.orn.rotateZVec(overlay_angle  ); // rotate along z axis
   m.scaleOrn      (overlay_scale  ); // scale the overlay
   Game::World.terrainAddOverlay(WHITE,overlay_gfx,m);

   Memb<Game::Obj*> objects;
   Game::World.objQuery(objects,Ball(overlay_scale*SQRT3+1,pos),OBJ_ITEM); // get objects in explosion radius
   REPA(objects)if(Item *item=CAST(Item,objects[i])) // process world items to add overlays and apply forces to actors
   {
      // apply forces to item actors
      Actor &actor=item->actor;
      Vec    dir  =actor.pos()-pos; // get difference between actor position and explosion position
      Flt    dist =dir.normalize(); // normalize direction and store its previous length into 'dist'
             dist*=dist;            // distance is now equal to squared distance

      if(dist)actor.addImpulse(30 * dir / dist); // final equation for impulse = (power) * (normalized direction) / (distance^2)

      // set mesh overlays for items
      if(item->mesh)
      {
         m.orn.setDir    (dir);
         m.orn.rotateZVec(overlay_angle);
         m.scaleOrn      (overlay_scale);
         if(!item->mesh_overlay.New().create(*item->mesh,overlay_gfx,m,&item->matrixScaled()))item->mesh_overlay.removeLast();
      }
   }
}
/******************************************************************************/
// ITEM
/******************************************************************************/
Item::Item()
{
   type=ITEM_NONE;
}
/******************************************************************************/
void Item::create(Game::ObjParams &obj)
{
   __super::create(obj);

   if(Game::Param *param=obj.findParam("type"))type=param->asEnum(); // set item type from .obj file
}
/******************************************************************************/
Bool Item::update()
{
   if(type==ITEM_MISSILE) // if this is a missile
   {
      Vec vec=actor.vel(); vec.setLength(0.35); // 35 cm
      if(actor.sweep(vec)) // if the missile actor has encountered an obstacle along the way
      {
         CreateExplosion(pos()); // create explosion at bomb's position
         return false; // return false which will delete the bomb Item
      }
   }

   REPA(mesh_overlay)if(mesh_overlay[i].update()) // update all overlays
      mesh_overlay.remove(i,true); // and remove them if they faded out

   return __super::update();
}
/******************************************************************************/
void Item::draw()
{
   __super::draw(); // call default drawing

   switch(Renderer())
   {
      case RM_OVERLAY: // mesh overlays need to be rendered in RM_OVERLAY mode
         REPAO(mesh_overlay).draw(matrixScaled()); // draw mesh_overlays with the same matrix used for default item drawing
      break;
   }
}
/******************************************************************************/
void Item::save(File &f)
{
   __super::save(f);

   f<<type;
   mesh_overlay.save(f);
}
Bool Item::load(File &f)
{
   if(__super::load(f))
   {
      f>>type;
      return mesh_overlay.load(f);
   }
   return false;
}
/******************************************************************************/
// MAIN
/******************************************************************************/
void InitPre()
{
   App.name="Big Overlays";
   App.flag=APP_FULL_TOGGLE|APP_MS_EXCLUSIVE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true).shdMapSize(1024).ambPower(0.3);

   ViewportFull.range=70;
   Cam.at.set(16,0,16);
   Cam.dist = 28;
   Cam.pitch=-PI_6;
}
/******************************************************************************/
Bool Init()
{
   Physics.create();
   Sun    .set   (*Gfxs("gfx/sky/sun.gfx")).power=1-D.ambPower(); Sun.rays.mode=SUN_RAYS_HIGH;
   Sky    .set   ();

   // increase default earthquake effect scale
   QuakeFx.scale*=3;

   Game::World.init   (                     )
              .setItem(Items,OBJ_ITEM       )
              .New    ("world/custom params");

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;

   CamHandle(0.1,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));

   Game::World.update(Cam.at);

   // update earthquake effect
   QuakeFx.update();

   // update explosions
   REPA(explosion)if(explosion[i].update())explosion.remove(i);

   if(Kb.bp(KB_SPACE)) // on space pressed
   {
      // create a 'bomb' item
      Game::ObjParams &bomb=*Game::Objs("obj/item/missile/bomb/0.obj");
      Game::World.objCreate(bomb,Matrix().setPosUp(Vec(RndF(13,19),14,RndF(13,19)),Vec(0,-1,0)).scaleOrn(bomb.scale()*2));
   }

   return true;
}
/******************************************************************************/
void Render()
{
   Game::World.draw();

   switch(Renderer())
   {
      case RM_PRT_PAL:
         REPA(explosion)explosion[i].draw();
      break;
   }
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,"Press Space to drop a Bomb");
}
/******************************************************************************/
